<?php defined('SYSPATH') or die('No direct script access.');

class Task_Serverstats_Update_CountImport extends Minion_Task
{
    
    protected function _execute(array $params)
    {
        Task_Helper::createWorker('Serverstats:Update:CountImport', $this);
    }

    public function Worker(GearmanJob $job)
    {
        $count = null;
        $client = Task_Helper::getImportClient();
        $client->setCompleteCallback(function($task) use(&$count)
        {
            $count = $task->data();
        });
        $client->addTask('Count', '_');
        $client->runTasks();
        
        if ($count >= 100000) {
            $count = '<span class="text-danger"><strong>' . $count . '</strong></span>';
        } elseif ($count >= 10000) {
            $count = '<span class="text-danger">' . $count . '</span>';
        }

        Model_Serverstat::setStat('CountImport', $count);
    }
    
}